# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sddefinition import *
from .sdtype import *
from .sdapiobject import *
from .sdtype import *
from .sdapiobject import *
from .apiexception import APIException

class SDModule(SDAPIObject):
    """
    A SDModule is a set of related SDDefinition and SDType
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDModule
        """
        super(SDModule, self).__init__(APIContext, handle, *args, **kwargs)

    def getId(self) -> str:
        """
        Get the identifier of the module

        """
        outId = ctypes.c_char_p()
        _res = self.mAPIContext.SDModule_getId(self.mHandle, ctypes.byref(outId))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outId.value.decode('utf-8') # type: ignore

    def getDefinitions(self) -> SDArray[SDDefinition]:
        """
        Get all SDDefinition available in the current module

        """
        outSDDefinitionArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDModule_getDefinitions(self.mHandle, ctypes.byref(outSDDefinitionArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDDefinitionArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDDefinitionArray.value, ownHandle=True)

    def getDefinitionFromId(self, sdDefinitionId : str) -> Optional[SDDefinition]:
        """
        Get the SDDefinition that matches the specified identifier

        :param sdDefinitionId: The identifier of the SDDefinition to retrieve
        """
        outSDDefinition = ctypes.c_void_p()
        _res = self.mAPIContext.SDModule_getDefinitionFromId(self.mHandle, ctypes.create_string_buffer(sdDefinitionId.encode('utf-8')), ctypes.byref(outSDDefinition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDDefinition, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDDefinition.value, ownHandle=True)

    def getTypes(self) -> SDArray[SDType]:
        """
        Get all SDTypes declared in the current module

        """
        outSDTypeArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDModule_getTypes(self.mHandle, ctypes.byref(outSDTypeArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDTypeArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDTypeArray.value, ownHandle=True)

    def getTypeFromId(self, sdTypeId : str) -> Optional[SDType]:
        """
        Get the SDType that matches the specified identifier

        :param sdTypeId: The identifier of the SDType to retrieve
        """
        outSDType = ctypes.c_void_p()
        _res = self.mAPIContext.SDModule_getTypeFromId(self.mHandle, ctypes.create_string_buffer(sdTypeId.encode('utf-8')), ctypes.byref(outSDType))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDType, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDType.value, ownHandle=True)

